# OpenJDK Support in Nanite

Nanite supports the class library found in OpenJDK, specifically version jdk7u141-b01.

Such support allows for high-level Java types and classes that are present in the class library to be used with Nanite
applications.  Due to the nature of targeting embedded hardware with limited CPU and RAM resources certain elements
have been removed or changed to be optimized for such targets.  This document provides a high-level overview of the 
elements that can be used within Nanite applications.

## Core Language

All Java core language types found in the **java.lang** namespace are supported with the following exceptions:

  1. **java.lang.reflect** is not supported due to the lack of reflection support provided by the Nanite VM.
  1. Strict math is not supported due to the lack of native support in the Nanite VM.
  1. Processes cannot be spawned within the Nanite VM.
  1. While Java threads are supported, thread groups are not.
  1. Serialization is not supported as reflection is required to de-serialize.
  1. Security managers are not supported.
  1. Finalizers are not supported. (As Java does not guarantee that finalizers ever run, technically this is a correct implementation of finalizers.)
  1. Double-float (and floating point math) support is optional and can be elided if the application does not require it. However, note that many core Java classes depend on floating point in unexpected ways, so be sure to test your application thoroughly before disabling double float or general float support.
 
Supported core language types include:

  * Boolean
  * Byte
  * Class
  * Character
  * Double
  * Enum
  * Float
  * Integer
  * Long
  * Object
  * Thread
  * Short
  * String
  * StringBuffer
  * StringBuilder
  * System
  * Void
  
## Collections

All of the Java collection types found within the **java.util** namespace are available in Nanite with the 
following exceptions:

  1. Serialization is not supported due to the lack of reflection support provided by the Nanite VM.
  1. UUIDs are not supported due to missing native support.
  1. The ServiceLoader is not supported due to the lack of reflection support provided by the Nanite VM.
  1. The concurrent variants of the Java collection types are not supported due to the lack of reflection support provided by the Nanite VM.

Supported collection and utility classes include the following:

  * ArrayDeque
  * ArrayList
  * Arrays
  * BitSet
  * Calendar
  * Collections
  * ComparableTimSort
  * Currency
  * Date
  * Dictionary
  * DualPivotQuicksort
  * EnumMap
  * EnumSet
  * EventObject
  * Formatter
  * GregorianCalendar
  * HashMap
  * HashSet
  * Hashtable
  * IdentityHashMap
  * JapaneseImperialCalendar
  * JumboEnumSet
  * LinkedHashMap
  * LinkedHashSet
  * LinkedList
  * List
  * Locale
  * LocaleISOData
  * Map
  * Objects
  * Observable
  * PriorityQueue
  * Properties
  * Queue
  * Random
  * RegularEnumSet
  * Scanner
  * Set
  * SimpleTimeZone
  * Stack
  * StringTokenizer
  * Timer
  * TimerTask
  * TimeZone
  * TimSort
  * TreeMap
  * TreeSet
  * Vector
  * WeakHashMap

## Geometry

All geometry data types found in the **java.awt.geom** namespace are supported.  This includes types such as:

  * AffineTransform
  * Arc2D
  * Area
  * CubicCurve2D
  * Dimension2D
  * Ellipse2D
  * FlatteningPathIterator
  * GeneralPath
  * Line2D
  * Path2D
  * Point2D
  * QuadCurve2D
  * Rectangle2D
  * RectangularShape
  * RoundRectangle2D
  
In addition the basic shape types found in the **java.awt** namespace are supported as follows:

  * Dimension
  * Point
  * Rectangle
  * Shape
  
Finally the geometry types found in the **sun.awt.geom** namespace are also available as follows:

  * AreaOp
  * ChainEnd
  * Crossings
  * Curve
  * CurveLink
  * Edge
  * Order
  * PathConsumer2D
  
## I/O

All stream based I/O found in the **java.io** namespace are available with the following exceptions:

  1. All file-based streams and operations are not supported due to the lack of file system support in Nanite. 
  1. Serialization is not supported due to the lack of reflection support provided by the Nanite VM.
  1. ObjectStreams are not supported due to the lack of reflection support provided by the Nanite VM.
  1. Only the UTF-8 character set is supported due to memory limitations.  Other character sets can be used via manual instantiation.
  
Supported I/O classes include the following:

  * Bits
  * BufferedInputStream
  * BufferedOutputStream
  * BufferedReader
  * BufferedWriter
  * ByteArrayInputStream
  * ByteArrayOutputStream
  * CharArrayReader
  * CharArrayWriter
  * DataInputStream
  * DataOutputStream
  * FilterInputStream
  * FilterOutputStream
  * FilterReader
  * FilterWriter
  * InputStream
  * InputStreamReader
  * PipedInputStream
  * PipedOutputStream
  * PipedReader
  * PipedWriter
  * PrintStream
  * PrintWriter
  * PushbackInputStream
  * PushbackReader
  * Reader
  * SequenceInputStream
  * StreamTokenizer
  * StringReader
  * StringWriter
  * Writer
  
## Math

All math support found in **java.math** is available in Nanite.  This includes the following classes:

  * BigDecimal
  * BigInteger
  * BitSieve
  * MutableBigInteger
  * SignedMutableBigInteger
   
## Networking

Networking and BLE support in Nanite is provided via Nanite specific class libraries and stacks.  As a result the IP 
and socket classes that are provided in the **java.net** namespace are not available.  However the data types used to
represent both v4 and v6 IP addresses as well as URL/URIs are available under Nanite.  The classes available include:

  * Inet4Address
  * Inet6Address
  * InetAddress
  * URI
  * URL
  * URLDecoder
  * URLEncoder 
  
## Regular Expressions

The regular expression types found within the **java.util.regex** namespace are available in Nanite.  The only
restriction is that the available character sets are limited to UTF-8 due to limited memory requirements. Code for the 
additional character sets is available but requires manual instantiation. Supported classes include: 

  * ASCII
  * Matcher
  * Pattern
  
## Text

The classes found within the **java.text** namespace are available in Nanite.  These classes allow for formatting and 
parsing of dates and times as well as number formats.  The only restriction is that the available character sets are 
limited to UTF-8 due to limited memory requirements.  Code for the additional character sets is available but requires 
manual instantiation.  Supported classes include:

  * AttributedString
  * BreakDictionary
  * CalendarBuilder
  * Collator
  * DateFormat
  * DecimalFormat
  * DigitList
  * EntryPair
  * Format
  * MergeCollation
  * MessageFormat
  * Normalizer
  * NumberFormat
  * PatternEntry
  * RuleBasedCollator
  * SimpleDateFormat

Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
Copyright (C) 2017 Wearable, Inc.
Last Updated: Aug 12th 2020
