/*
 * Copyright (c) 1996, 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/* NANITE: Reflection & Security is not supported */
package java.io;

import java.lang.reflect.InvocationTargetException;


import org.naniteproject.annotation.NaniteNotImplemented;

/**
 * Serialization's descriptor for classes.  It contains the name and
 * serialVersionUID of the class.  The ObjectStreamClass for a specific class
 * loaded in this Java VM can be found/created using the lookup method.
 *
 * <p>The algorithm to compute the SerialVersionUID is described in
 * <a href="../../../platform/serialization/spec/class.html#4100">Object
 * Serialization Specification, Section 4.6, Stream Unique Identifiers</a>.
 *
 * @author      Mike Warres
 * @author      Roger Riggs
 * @see ObjectStreamField
 * @see <a href="../../../platform/serialization/spec/class.html">Object Serialization Specification, Section 4, Class Descriptors</a>
 * @since   JDK1.1
 */
@NaniteNotImplemented("Reflection not supported")
public class ObjectStreamClass implements Serializable {

    /**
     * serialPersistentFields value indicating no serializable fields
     */
    /* NANITE: Reflection not supported */

    //public static final ObjectStreamField[] NO_FIELDS =
    ///        new ObjectStreamField[0];


    /**
     * Find the descriptor for a class that can be serialized.  Creates an
     * ObjectStreamClass instance if one does not exist yet for class. Null is
     * returned if the specified class does not implement java.io.Serializable
     * or java.io.Externalizable.
     *
     * @param cl class for which to get the descriptor
     * @return the class descriptor for the specified class
     */
    @NaniteNotImplemented("Reflection not supported")
    public static ObjectStreamClass lookup(Class<?> cl) {
        return lookup(cl, false);
    }

    /**
     * Returns the descriptor for any class, regardless of whether it
     * implements {@link Serializable}.
     *
     * @param cl class for which to get the descriptor
     * @return the class descriptor for the specified class
     * @since 1.6
     */
    @NaniteNotImplemented("Reflection not supported")
    public static ObjectStreamClass lookupAny(Class<?> cl) {
        return lookup(cl, true);
    }

    /**
     * Returns the name of the class described by this descriptor.
     * This method returns the name of the class in the format that
     * is used by the {@link Class#getName} method.
     *
     * @return a string representing the name of the class
     */
    @NaniteNotImplemented("Reflection not supported")
    public String getName() {
        return null;
    }

    /**
     * Return the serialVersionUID for this class.  The serialVersionUID
     * defines a set of classes all with the same name that have evolved from a
     * common root class and agree to be serialized and deserialized using a
     * common format.  NonSerializable classes have a serialVersionUID of 0L.
     *
     * @return the SUID of the class described by this descriptor
     */
    @NaniteNotImplemented("Reflection not supported")
    public long getSerialVersionUID() {
        // REMIND: synchronize instead of relying on volatile?
        return 0;
    }

    /**
     * Return the class in the local VM that this version is mapped to.  Null
     * is returned if there is no corresponding local class.
     *
     * @return the <code>Class</code> instance that this descriptor represents
     */
    @NaniteNotImplemented("Reflection not supported")
    public Class<?> forClass() {
        return null;
    }

    /**
     * Return an array of the fields of this serializable class.
     *
     * @return an array containing an element for each persistent field of
     * this class. Returns an array of length zero if there are no
     * fields.
     * @since 1.2
     */
    @NaniteNotImplemented("Reflection not supported")
    public ObjectStreamField[] getFields() {
        return getFields(true);
    }

    /**
     * Get the field of this class by name.
     *
     * @param name the name of the data field to look for
     * @return The ObjectStreamField object of the named field or null if
     * there is no such named field.
     */
    @NaniteNotImplemented("Reflection not supported")
    public ObjectStreamField getField(String name) {
        return getField(name, null);
    }

    /**
     * Return a string describing this ObjectStreamClass.
     */
    @NaniteNotImplemented("Reflection not supported")
    public String toString() {
        return "";
    }

    /**
     * Looks up and returns class descriptor for given class, or null if class
     * is non-serializable and "all" is set to false.
     *
     * @param cl  class to look up
     * @param all if true, return descriptors for all classes; if false, only
     *            return descriptors for serializable classes
     */
    @NaniteNotImplemented("Reflection not supported")
    static ObjectStreamClass lookup(Class<?> cl, boolean all) {
        return null;
    }


    /**
     * Creates blank class descriptor which should be initialized via a
     * subsequent call to initProxy(), initNonProxy() or readNonProxy().
     */
    @NaniteNotImplemented("Reflection not supported")
    ObjectStreamClass() {
    }

    /**
     * Initializes class descriptor representing a proxy class.
     */
    @NaniteNotImplemented("Reflection not supported")
    void initProxy(Class<?> cl,
                   ClassNotFoundException resolveEx,
                   ObjectStreamClass superDesc)
            throws InvalidClassException {

    }

    /**
     * Initializes class descriptor representing a non-proxy class.
     */
    @NaniteNotImplemented("Reflection not supported")
    void initNonProxy(ObjectStreamClass model,
                      Class<?> cl,
                      ClassNotFoundException resolveEx,
                      ObjectStreamClass superDesc)
            throws InvalidClassException {

    }

    /**
     * Reads non-proxy class descriptor information from given input stream.
     * The resulting class descriptor is not fully functional; it can only be
     * used as input to the ObjectInputStream.resolveClass() and
     * ObjectStreamClass.initNonProxy() methods.
     */
    @NaniteNotImplemented("Reflection not supported")
    void readNonProxy(ObjectInputStream in)
            throws IOException, ClassNotFoundException {

    }

    /**
     * Writes non-proxy class descriptor information to given output stream.
     */
    @NaniteNotImplemented("Reflection not supported")
    void writeNonProxy(ObjectOutputStream out) throws IOException {

    }

    /**
     * Returns ClassNotFoundException (if any) thrown while attempting to
     * resolve local class corresponding to this class descriptor.
     */
    @NaniteNotImplemented("Reflection not supported")
    ClassNotFoundException getResolveException() {
        return null;
    }


    /**
     * Throws an InvalidClassException if object instances referencing this
     * class descriptor should not be allowed to deserialize.  This method does
     * not apply to deserialization of enum constants.
     */
    @NaniteNotImplemented("Reflection not supported")
    void checkDeserialize() throws InvalidClassException {

    }

    /**
     * Throws an InvalidClassException if objects whose class is represented by
     * this descriptor should not be allowed to serialize.  This method does
     * not apply to serialization of enum constants.
     */
    @NaniteNotImplemented("Reflection not supported")
    void checkSerialize() throws InvalidClassException {

    }

    /**
     * Throws an InvalidClassException if objects whose class is represented by
     * this descriptor should not be permitted to use default serialization
     * (e.g., if the class declares serializable fields that do not correspond
     * to actual fields, and hence must use the GetField API).  This method
     * does not apply to deserialization of enum constants.
     */
    @NaniteNotImplemented("Reflection not supported")
    void checkDefaultSerialize() throws InvalidClassException {

    }

    /**
     * Returns superclass descriptor.  Note that on the receiving side, the
     * superclass descriptor may be bound to a class that is not a superclass
     * of the subclass descriptor's bound class.
     */
    @NaniteNotImplemented("Reflection not supported")
    ObjectStreamClass getSuperDesc() {
        return null;
    }

    /**
     * Returns the "local" class descriptor for the class associated with this
     * class descriptor (i.e., the result of
     * ObjectStreamClass.lookup(this.forClass())) or null if there is no class
     * associated with this descriptor.
     */
    @NaniteNotImplemented("Reflection not supported")
    ObjectStreamClass getLocalDesc() {
        return null;
    }

    /**
     * Returns arrays of ObjectStreamFields representing the serializable
     * fields of the represented class.  If copy is true, a clone of this class
     * descriptor's field array is returned, otherwise the array itself is
     * returned.
     */
    @NaniteNotImplemented("Reflection not supported")
    ObjectStreamField[] getFields(boolean copy) {
        return null;
    }

    /**
     * Looks up a serializable field of the represented class by name and type.
     * A specified type of null matches all types, Object.class matches all
     * non-primitive types, and any other non-null type matches assignable
     * types only.  Returns matching field, or null if no match found.
     */
    @NaniteNotImplemented("Reflection not supported")
    ObjectStreamField getField(String name, Class<?> type) {

        return null;
    }

    /**
     * Returns true if class descriptor represents a dynamic proxy class, false
     * otherwise.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean isProxy() {
        return false;
    }

    /**
     * Returns true if class descriptor represents an enum type, false
     * otherwise.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean isEnum() {
        return false;
    }

    /**
     * Returns true if represented class implements Externalizable, false
     * otherwise.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean isExternalizable() {
        return false;
    }

    /**
     * Returns true if represented class implements Serializable, false
     * otherwise.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean isSerializable() {
        return false;
    }

    /**
     * Returns true if class descriptor represents externalizable class that
     * has written its data in 1.2 (block data) format, false otherwise.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean hasBlockExternalData() {
        return false;
    }

    /**
     * Returns true if class descriptor represents serializable (but not
     * externalizable) class which has written its data via a custom
     * writeObject() method, false otherwise.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean hasWriteObjectData() {
        return false;
    }

    /**
     * Returns true if represented class is serializable/externalizable and can
     * be instantiated by the serialization runtime--i.e., if it is
     * externalizable and defines a public no-arg constructor, or if it is
     * non-externalizable and its first non-serializable superclass defines an
     * accessible no-arg constructor.  Otherwise, returns false.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean isInstantiable() {
        return false;
    }

    /**
     * Returns true if represented class is serializable (but not
     * externalizable) and defines a conformant writeObject method.  Otherwise,
     * returns false.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean hasWriteObjectMethod() {
        return false;
    }

    /**
     * Returns true if represented class is serializable (but not
     * externalizable) and defines a conformant readObject method.  Otherwise,
     * returns false.
     */
    boolean hasReadObjectMethod() {
        return false;
    }

    /**
     * Returns true if represented class is serializable (but not
     * externalizable) and defines a conformant readObjectNoData method.
     * Otherwise, returns false.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean hasReadObjectNoDataMethod() {
        return false;
    }

    /**
     * Returns true if represented class is serializable or externalizable and
     * defines a conformant writeReplace method.  Otherwise, returns false.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean hasWriteReplaceMethod() {
        return false;
    }

    /**
     * Returns true if represented class is serializable or externalizable and
     * defines a conformant readResolve method.  Otherwise, returns false.
     */
    @NaniteNotImplemented("Reflection not supported")
    boolean hasReadResolveMethod() {
        return false;
    }

    /**
     * Creates a new instance of the represented class.  If the class is
     * externalizable, invokes its public no-arg constructor; otherwise, if the
     * class is serializable, invokes the no-arg constructor of the first
     * non-serializable superclass.  Throws UnsupportedOperationException if
     * this class descriptor is not associated with a class, if the associated
     * class is non-serializable or if the appropriate no-arg constructor is
     * inaccessible/unavailable.
     */
    @NaniteNotImplemented("Reflection not supported")
    Object newInstance()
            throws InstantiationException, InvocationTargetException,
            UnsupportedOperationException {
        return false;
    }

    /**
     * Invokes the writeObject method of the represented serializable class.
     * Throws UnsupportedOperationException if this class descriptor is not
     * associated with a class, or if the class is externalizable,
     * non-serializable or does not define writeObject.
     */
    @NaniteNotImplemented("Reflection not supported")
    void invokeWriteObject(Object obj, ObjectOutputStream out)
            throws IOException, UnsupportedOperationException {

    }

    /**
     * Invokes the readObject method of the represented serializable class.
     * Throws UnsupportedOperationException if this class descriptor is not
     * associated with a class, or if the class is externalizable,
     * non-serializable or does not define readObject.
     */
    @NaniteNotImplemented("Reflection not supported")
    void invokeReadObject(Object obj, ObjectInputStream in)
            throws ClassNotFoundException, IOException,
            UnsupportedOperationException {

    }

    /**
     * Invokes the readObjectNoData method of the represented serializable
     * class.  Throws UnsupportedOperationException if this class descriptor is
     * not associated with a class, or if the class is externalizable,
     * non-serializable or does not define readObjectNoData.
     */
    @NaniteNotImplemented("Reflection not supported")
    void invokeReadObjectNoData(Object obj)
            throws IOException, UnsupportedOperationException {

    }

    /**
     * Invokes the writeReplace method of the represented serializable class and
     * returns the result.  Throws UnsupportedOperationException if this class
     * descriptor is not associated with a class, or if the class is
     * non-serializable or does not define writeReplace.
     */
    @NaniteNotImplemented("Reflection not supported")
    Object invokeWriteReplace(Object obj)
            throws IOException, UnsupportedOperationException {
        return null;

    }

    /**
     * Invokes the readResolve method of the represented serializable class and
     * returns the result.  Throws UnsupportedOperationException if this class
     * descriptor is not associated with a class, or if the class is
     * non-serializable or does not define readResolve.
     */
    @NaniteNotImplemented("Reflection not supported")
    Object invokeReadResolve(Object obj)
            throws IOException, UnsupportedOperationException {
        return null;
    }

    /**
     * Class representing the portion of an object's serialized form allotted
     * to data described by a given class descriptor.  If "hasData" is false,
     * the object's serialized form does not contain data associated with the
     * class descriptor.
     */
    static class ClassDataSlot {

        /**
         * class descriptor "occupying" this slot
         */
        final ObjectStreamClass desc;
        /**
         * true if serialized form includes data for this slot's descriptor
         */
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass desc, boolean hasData) {
            this.desc = desc;
            this.hasData = hasData;
        }
    }

    /**
     * Returns array of ClassDataSlot instances representing the data layout
     * (including superclass data) for serialized objects described by this
     * class descriptor.  ClassDataSlots are ordered by inheritance with those
     * containing "higher" superclasses appearing first.  The final
     * ClassDataSlot contains a reference to this descriptor.
     */
    @NaniteNotImplemented("Reflection not supported")
    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        // REMIND: synchronize instead of relying on volatile?
        return null;
    }


    /**
     * Returns aggregate size (in bytes) of marshalled primitive field values
     * for represented class.
     */
    @NaniteNotImplemented("Reflection not supported")
    int getPrimDataSize() {
        return 0;
    }

    /**
     * Returns number of non-primitive serializable fields of represented
     * class.
     */
    @NaniteNotImplemented("Reflection not supported")
    int getNumObjFields() {
        return 0;
    }

    /**
     * Fetches the serializable primitive field values of object obj and
     * marshals them into byte array buf starting at offset 0.  It is the
     * responsibility of the caller to ensure that obj is of the proper type if
     * non-null.
     */
    @NaniteNotImplemented("Reflection not supported")
    void getPrimFieldValues(Object obj, byte[] buf) {

    }

    /**
     * Sets the serializable primitive fields of object obj using values
     * unmarshalled from byte array buf starting at offset 0.  It is the
     * responsibility of the caller to ensure that obj is of the proper type if
     * non-null.
     */
    @NaniteNotImplemented("Reflection not supported")
    void setPrimFieldValues(Object obj, byte[] buf) {

    }

    /**
     * Fetches the serializable object field values of object obj and stores
     * them in array vals starting at offset 0.  It is the responsibility of
     * the caller to ensure that obj is of the proper type if non-null.
     */
    @NaniteNotImplemented("Reflection not supported")
    void getObjFieldValues(Object obj, Object[] vals) {
    }

    /**
     * Sets the serializable object fields of object obj using values from
     * array vals starting at offset 0.  It is the responsibility of the caller
     * to ensure that obj is of the proper type if non-null.
     */
    @NaniteNotImplemented("Reflection not supported")
    void setObjFieldValues(Object obj, Object[] vals) {
    }
}