/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

#ifndef CONSTANTS_H
#define CONSTANTS_H

#include <stdbool.h>

#include "specialclasses.h"

// Standard Java types & primitives.
// These must match the values used by the linker and the corresponding
// entries in classes.db/specialclasses.h
#define T_REFERENCE 0
#define T_CLASS 2
#define T_BOOLEAN 4
#define T_CHAR 5
#define T_FLOAT 6
#define T_DOUBLE 7
#define T_BYTE 8
#define T_SHORT 9
#define T_INT 10
#define T_LONG 11
#define T_VOID 12

// Special class value used to represent free space by the GC. We use
// a void array entry which is not a valid type in Java.
#define T_FREE AV

#define NVM_VERSION 1

#endif
