/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

#include "classes.h"

void nvm_object_array_size_set(Object* object, byte size)
{
    object->flags.bits  = nvm_object_class_index(object);
    object->flags.bits |= ((uint16_t)0x3F & size) << 7;
}

void nvm_object_init(Object* object, nvm_class_index_t class_index, _Bool is_array, byte size)
{
    object->flags.bits = class_index;
    object->flags.is_array = is_array;
    if (is_array) {
        nvm_object_array_size_set(object, size);
    }
}

_Bool nvm_object_is_array_std(Object* object)
{
    return object->flags.is_array && nvm_object_array_size(object) < LEN_BIGARRAY;
}

_Bool nvm_object_is_array_big(Object* object)
{
    return object->flags.is_array && nvm_object_array_size(object) == LEN_BIGARRAY;
}

_Bool nvm_object_is_array_ah(Object* object)
{
    return object->flags.is_array && nvm_object_array_size(object) == LEN_AHARRAY;
}

nvm_array_size_t nvm_array_size(Object* object)
{
    nvm_array_size_t size = nvm_object_array_size(object);
    return size < LEN_BIGARRAY ? size : ((BigArray*)(void*)object)->length;
}


