/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

/**
 * This is included inside a switch statement.
 */

OPCODE(OP_ISHL)
  // Arguments: 0
  // Stack: -2 +1
  {
    STACKWORD tempStackWord = pop_word();
    just_set_top_word (get_top_word() << (tempStackWord & 0x1F));
  }
  DISPATCH;

OPCODE(OP_ISHR)
  // Arguments: 0
  // Stack: -2 +1
  {
    STACKWORD tempStackWord = pop_word();
    just_set_top_word (word2jint(get_top_word()) >> (tempStackWord & 0x1F));
  }
  DISPATCH;

OPCODE(OP_IUSHR)
  // Arguments: 0
  // Stack: -2 +1
  {
    STACKWORD tempStackWord = pop_word();
    just_set_top_word (get_top_word() >> (tempStackWord & 0x1F));
  }
  DISPATCH;

OPCODE(OP_IAND)
  {
    STACKWORD tempStackWord = pop_word();
    just_set_top_word (get_top_word() & tempStackWord);
  }
  DISPATCH;

OPCODE(OP_IOR)
  {
    STACKWORD tempStackWord = pop_word();
    just_set_top_word (get_top_word() | tempStackWord);
  }
  DISPATCH;

OPCODE(OP_IXOR)
  {
    STACKWORD tempStackWord = pop_word();
    just_set_top_word (get_top_word() ^ tempStackWord);
  }
  DISPATCH;

OPCODE(OP_LSHL)
  // Arguments) 0
  // Stack) -3 +1
  {
    STACKWORD tempStackWord = pop_word();
    JLONG l1;
    pop_jlong(&l1);
    l1 <<= (tempStackWord & 0x3F);
    push_jlong(&l1);
  }
  DISPATCH;

OPCODE(OP_LSHR)
  // Arguments) 0
  // Stack) -3 +1
  {
    STACKWORD tempStackWord = pop_word();
    JLONG l1;
    pop_jlong(&l1);
    l1 >>= (tempStackWord & 0x3F);
    push_jlong(&l1);
  }
  DISPATCH;

OPCODE(OP_LUSHR)
  // Arguments) 0
  // Stack) -3 +1
  {
    STACKWORD tempStackWord = pop_word();
    JLONG l1;
    pop_jlong(&l1);
    l1 = (LLONG)(((ULLONG)l1) >> (tempStackWord & 0x3F));
    push_jlong(&l1);
  }
  DISPATCH;

OPCODE(OP_LAND)
  {
    JLONG l1, l2;
    pop_jlong(&l1);
    pop_jlong(&l2);
    l2 &= l1;
    push_jlong(&l2);
  }
  DISPATCH;

OPCODE(OP_LOR)
  {
    JLONG l1, l2;
    pop_jlong(&l1);
    pop_jlong(&l2);
    l2 |= l1;
    push_jlong(&l2);
  }
  DISPATCH;

OPCODE(OP_LXOR)
  {
    JLONG l1, l2;
    pop_jlong(&l1);
    pop_jlong(&l2);
    l2 ^= l1;
    push_jlong(&l2);
  }
  DISPATCH;

/*end*/
