/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

/**
 * This is included inside a switch statement.
 */

OPCODE(OP_ATHROW)
  {
    REFERENCE tempStackWord = pop_ref();
    if (ref_null_p(tempStackWord)) {
      goto LABEL_THROW_NULLPTR_EXCEPTION;
    }
    SAVE_REGS(pState);
    nvm_throw_exception(pState, (Throwable *)ref2obj(tempStackWord));
    LOAD_REGS(pState);
  }
  DISPATCH_CHECKED;

OPCODE(OP_MONITORENTER)
  {
    Object *obj = ref2obj(get_top_ref());
    SAVE_REGS(pState);
    enter_monitor (pState, pState->current_thread, obj);
    LOAD_REGS(pState);
    just_pop_ref();
  }
  DISPATCH_CHECKED;

OPCODE(OP_MONITOREXIT)
  {
    Object *obj = ref2obj(get_top_ref());
    SAVE_REGS(pState);
    exit_monitor (pState, pState->current_thread, obj);
    LOAD_REGS(pState);
    just_pop_ref();
  }
  DISPATCH_CHECKED;

// Notes:
// - Not supported: BREAKPOINT

/*end*/
