/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

#ifndef _TRACE_H
#define _TRACE_H

#include "types.h"

#ifdef VERIFY

#define INTERPRETER0   10
#define INTERPRETER1   11
#define INTERPRETER2   12
#define INTERPRETER3   13
#define INTERPRETER4   14
#define INTERPRETER5   15
#define INTERPRETER6   16

#define THREADS0       20
#define THREADS1       21
#define THREADS2       22
#define THREADS3       23
#define THREADS4       24
#define THREADS5       25
#define THREADS6       26
#define THREADS7       27
#define THREADS8       28
#define THREADS9       29

#define MEMORY0        30
#define MEMORY1        31
#define MEMORY2        32
#define MEMORY3        33
#define MEMORY4        34
#define MEMORY5        35
#define MEMORY6        36
#define MEMORY7        37
#define MEMORY8        38
#define MEMORY9        39

#define EXCEPTIONS0    40
#define EXCEPTIONS1    41

#define LANGUAGE0    50
#define LANGUAGE1    51
#define LANGUAGE2    52
#define LANGUAGE3    53

#define BAD_MAGIC	 54

#define ASSERT_TOP	100

#define assert(cond, code)  assert_hook( cond, code);

void assert_hook (boolean aCond, int aCode);

#else

#define assert(x,y)  ;

#endif

#ifndef NVM_DEBUG_MEMORY
#define NVM_DEBUG_MEMORY      0
#endif

#ifndef NVM_DEBUG_THREADS
#define NVM_DEBUG_THREADS     0
#endif

#ifndef NVM_DEBUG_METHODS
#define NVM_DEBUG_METHODS     0
#endif

#ifndef NVM_DEBUG_BYTECODE
#define NVM_DEBUG_BYTECODE    0
#endif

#ifndef NVM_DEBUG_FIELDS
#define NVM_DEBUG_FIELDS      0
#endif

#ifndef NVM_DEBUG_OBJECTS
#define NVM_DEBUG_OBJECTS     0
#endif

#ifndef NVM_DEBUG_EXCEPTIONS
#define NVM_DEBUG_EXCEPTIONS  0
#endif

#ifndef NVM_DEBUG_MONITOR
#define NVM_DEBUG_MONITOR     0
#endif

#endif
