/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

package org.naniteproject;

import java.io.OutputStream;

public class NaniteOutputStream extends OutputStream {
	
	private static native void writeChar(char c);
	
	@Override
	public void write(int c) {
		char x = (char)(c & 0xFF);
		writeChar(x);
	}

	private static native void flushOutputStream();

	@Override
	public void flush() {
		flushOutputStream();
	}

}
