/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

#ifndef _CONFIGURE_H
#define _CONFIGURE_H

#define FIXED_STACK_SIZE		0

#if FIXED_STACK_SIZE

/**
 * Initial level of recursion.
 */
#define INITIAL_STACK_FRAMES             10

/**
 * Initial number of words in a thread's stack
 * (for both locals and operands). Needs to be an
 * even number.
 */
#define INITIAL_STACK_SIZE               70

#else

#define INITIAL_STACK_FRAMES             8
#define INITIAL_STACK_SIZE               32

#endif

/**
 * If not 0, threads in the DEAD state are
 * removed from the circular list. Recommended.
 */
#define REMOVE_DEAD_THREADS              1

/**
 * Slightly safer code (?)
 */
#define SAFE                             1

/**
 * Schedule tasks based on time, and run the gc on a periodic interval.
 * If not set, scheduling will occur as a result of events, thread
 * operations (starting/waiting/etc), and for timeouts
 * (wait with timeout, sleep) only.
 */
#define TIME_SCHEDULING                  1

/**
 * Max number of VM objects that we need to protect, from the gc.
 */
#define MAX_VM_REFS                      8

/**
 * If not 0, make references relative to the state object.
 * Necessary to run the Nanite VM on a 64-bit system; otherwise, it's
 * an unnecessary speed penalty.
 */
#ifdef __LP64__
#define RELATIVE_REFERENCES              1
#else
#define RELATIVE_REFERENCES              0
#endif

/**
 * Choose the type of interpreter loop to use. Set to none zero
 * for the faster, gcc specific direct jump code.
 */

// Workaround for JetBrains CLion lack of support for GNU label-as-value extension
#ifndef __CIDR_clang__has_feature_c_static_assert
#define FAST_DISPATCH                    1
#endif

/**
 * Max number of HW events that can occur at one time
 */
enum {
    NVM_EVT_SHUTDOWN = 0,
    NVM_EVT_PLATFORM = 1,
    NVM_EVT_SIDE_CHANNEL = 2,
    NVM_EVT_IO_GPIO = 3,
    NVM_EVT_IO_GPIOTE = 4,
    NVM_EVT_IO_I2C_SLAVE = 5,
    NVM_EVT_IO_I2C_MASTER = 6,
    NVM_EVT_IO_SPI_MASTER = 7,
    NVM_EVT_IO_USB = 8,
    MAX_EVENTS    /* Add new events before this line. */

};

/**
 * The magic number used to ensure that the linker was used.
 */
#define MAGIC 0xCAF8

#endif
