/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

/**
 * This is included inside a switch statement.
 */

OPCODE(OP_I2B)
  just_set_top_word ((JBYTE) word2jint(get_top_word()));
  DISPATCH;

OPCODE(OP_I2S)
  just_set_top_word ((JSHORT) word2jint(get_top_word()));
  DISPATCH;

OPCODE(OP_I2C)
  just_set_top_word ((JCHAR) word2jint(get_top_word()));
  DISPATCH;

OPCODE(OP_L2I)
  // Arguments: 0
  // Stack: -2 +1
  {
    JLONG l1;
    pop_jlong(&l1);
    push_word((JINT) l1);
  }
  DISPATCH;

OPCODE(OP_I2L)
  {
    JLONG l1;
    l1 = (LLONG) pop_jint();
    push_jlong(&l1);
  }
  DISPATCH;

#if FP_ARITHMETIC

OPCODE(OP_I2F)
  // Arguments: 0
  // Stack: -1 +1
  just_set_top_word (jfloat2word ((JFLOAT) word2jint(get_top_word())));
  DISPATCH;

OPCODE(OP_F2I)
  // Arguments: 0
  // Stack: -1 +1
  just_set_top_word ((JINT) word2jfloat(get_top_word()));
  DISPATCH;

OPCODE(OP_L2F)
  {
    JLONG l1;
    pop_jlong(&l1);
    push_word (jfloat2word ((JFLOAT) l1));
  }
  DISPATCH;

OPCODE(OP_F2L)
  {
    STACKWORD tempStackWord = pop_word();
    JLONG l1;
    l1 = (LLONG)word2jfloat(tempStackWord);
    push_jlong(&l1);
  }
  DISPATCH;

#endif // FP_ARITHMETIC

#if FP_DOUBLE_ARITHMETIC

OPCODE(OP_I2D)
  // Arguments: 0
  // Stack: -1 +2
  {
    JDOUBLE d1;
    d1 = (double) (int) pop_word();
    push_jdouble(&d1);
  }
  DISPATCH;

OPCODE(OP_D2I)
  // Arguments: 0
  // Stack: -2 +1  
  {
    JDOUBLE d1;
    pop_jdouble(&d1);
    push_word((JINT) d1);
  }
  DISPATCH;

OPCODE(OP_F2D)
  // Arguments: 0
  // Stack: -1 +2
  {
    JDOUBLE d1;
    d1 = (double)word2jfloat(pop_word());
    push_jdouble(&d1);
  }
  DISPATCH;

OPCODE(OP_D2F)
  // Arguments: 0
  // Stack: -2 +1
  {
    JDOUBLE d1;
    pop_jdouble(&d1);
    push_word(jfloat2word((float) d1));
  }
  DISPATCH;

OPCODE(OP_L2D)
  {
    JLONG l1;
    JDOUBLE d1;
    pop_jlong(&l1);
    d1 = (double) l1;
    push_jdouble(&d1);
  }
  DISPATCH;

OPCODE(OP_D2L)
  {
    JLONG l1;
    JDOUBLE d1;
    pop_jdouble(&d1);
    l1 = (LLONG)d1;
    push_jlong(&l1);
  }
  DISPATCH;

#endif // FP_DOUBLE_ARITHMETIC

/*end*/


