/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

#include "state.h"
#include "specialclasses.h"

void init_state(nvm_state_t* pState)
{
    memset(pState, 0, sizeof(nvm_state_t));
    pState->wake_time = APOCALYPSE;
    pState->program_offset = -1;
    pState->gc_lock.flags.is_array = 0;
    pState->gc_lock.flags.bits = JAVA_LANG_OBJECT;
    pState->gc_lock.flags.mark = GC_BLACK;
    pState->gc_phase = GC_IDLE;
    pState->gc_free_list = FL_END;
}


