/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

#include <math.h>
#include <float.h>
#include "types.h"

int fcmp(JFLOAT f1, JFLOAT f2)
{
    return fabsf(f1 - f2) < FLT_EPSILON;
}

#if FP_DOUBLE_ARITHMETIC
int dcmp(double f1, double f2)
{
    return fabs(f1 - f2) < DBL_EPSILON;
}
#endif


