/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */

/**
 * This is included inside a switch statement.
 */

OPCODE(OP_INVOKEVIRTUAL)
  // Stack: (see method)
  // Arguments: 2
  // Note: pc is updated by dispatch method
  SAVE_REGS(pState);
  dispatch_virtual(pState, ref2obj(get_ref_at (pc[0] >> 4)), (uint16_t) pc[1] | ((uint16_t)(pc[0] & 0x0F) << 8), pc + 2);
  LOAD_REGS(pState);
  DISPATCH_CHECKED;

OPCODE(OP_INVOKEVIRTUAL2)
  // Stack: (see method)
  // Arguments: 2
  // Note: pc is updated by dispatch method
  SAVE_REGS(pState);
  dispatch_virtual(pState, ref2obj(get_ref_at (pc[0] >> 4)), ((uint16_t) pc[1] | ((uint16_t)(pc[0] & 0x0F) << 8)) + 0x1000, pc + 2);
  LOAD_REGS(pState);
  DISPATCH_CHECKED;

OPCODE(OP_INVOKESPECIAL)
OPCODE(OP_INVOKESTATIC)
  // Stack: (see method)
  // Arguments: 2
  // Note: pc is updated by dispatch method
  SAVE_REGS(pState);
  dispatch_special_checked_indirect(pState, (pc[0] << 8) | pc[1], pc + 2, pc - 1);
  LOAD_REGS(pState);
  DISPATCH_CHECKED;

OPCODE(OP_IRETURN)
OPCODE(OP_FRETURN)
OPCODE(OP_ARETURN)
  // Stack: 1 word copied up
  // Arguments: 0
  SAVE_REGS(pState);
  do_return (pState, 1);
  LOAD_REGS(pState);
  DISPATCH_CHECKED;

OPCODE(OP_LRETURN)
OPCODE(OP_DRETURN)
  // Stack: 2 words copied up
  // Arguments: 0
  SAVE_REGS(pState);
  do_return (pState, 2);
  LOAD_REGS(pState);
  DISPATCH_CHECKED;

OPCODE(OP_RETURN)
  // Stack: unchanged
  // Arguments: 0
  SAVE_REGS(pState);
  do_return (pState, 0);
  LOAD_REGS(pState);
  DISPATCH_CHECKED;

OPCODE(OP_INVOKEJAVA)
  // Call java method from VM
  SAVE_REGS(pState);
  dispatch_java(pState, pc[0], pc[1], pc + 2, pc -1);
  LOAD_REGS(pState);
  DISPATCH_CHECKED;


// Notes:
// * INVOKEINTERFACE cannot occur because it's replaced
//   by INVOKEVIRTUAL and a couple of NOOPs.

/*end*/

