/*
 * Copyright (C) 2018-2020 Western Digital Corporation or its affiliates
 * Copyright (C) 2017-2018 Wearable, Inc.
 * Copyright (C) 2000-2012 leJOS Contributors
 * Copyright (C) 2000 Jose H. Solorzano and TinyVM Contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 * 
 * This Source Code Form is “Incompatible With Secondary Licenses”,
 * as defined by the Mozilla Public License, v. 2.0.
 */
/**
 * poll.h
 * Contains conterparts of special classes as C structs.
 */
 
#ifndef _POLL_H
#define _POLL_H

#include "constants.h"
#include "classes.h"
#include "state.h"

void check_events(nvm_state_t* pState);
JINT poll_event(nvm_state_t* pState, JINT type);
boolean register_event(nvm_state_t* pState, Object *event, JINT type);
boolean unregister_event(nvm_state_t* pState, JINT type);
void init_events(nvm_state_t* pState);
void shutdown_program(nvm_state_t* pState);

#endif
